﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FireScript : MonoBehaviour {

    public List<Vector3> blacklistPoints = new List<Vector3>();
    Vector3 windDirection = new Vector3(0, 0, 0);
    public GameObject particleSystem;
    public float fireSpreadDelay = .75f;
    public float initialDelay = 1.5f;
    public float fireSpreadRange = .4f;

    private void Start()
    {
        Invoke("DoThing", initialDelay);
    }

    IEnumerator AddWhitelistPoints(Vector3 p)
    {
        yield return new WaitForSeconds(fireSpreadDelay);

        Vector3 point = new Vector3(Mathf.Round(p.x)+ windDirection.x, Mathf.Round(p.y)+ windDirection.y, Mathf.Round(p.z)+ windDirection.z);// Round point and affect with wind direction

        for (int y = -1; y < 2; y++)
        {
            for (int x = -1; x < 2; x++) 
            {
                for (int z = -1; z < 2; z++)
                {
                    if (!IsBlacklisted(point + new Vector3(x, y, z))) // If point isn't blacklisted
                    {
                        TryBurnPoint(point + new Vector3(x, y, z)); // Try burning it
                    }
                }
            }
        }
    }

    void DoThing()
    {
        TryBurnPoint(new Vector3(0, 0, 0));
    }

    void TryBurnPoint(Vector3 p)
    {
        Collider[] hitPoints = Physics.OverlapSphere(p,fireSpreadRange);
        blacklistPoints.Add(p); // Blacklist it

        for (int i=0;i<hitPoints.Length;i++)
        {
            if (BurnTarget(hitPoints[i].gameObject))
            {
                StartCoroutine(AddWhitelistPoints(p));
            }
        }
    }

    bool BurnTarget(GameObject g)
    {
        if (g.GetComponent<FireState>() != null)
        {
            return false;
        }
        if (g.GetComponent<BurnableObject>() != null)
        {
            g.AddComponent<FireState>();
            FireState fireObject = (FireState)g.AddComponent<FireState>();
            fireObject.particleEffect = particleSystem;
            fireObject.target = g;
            fireObject.StartEffect();
            return true;
        }
        else if (g.GetComponent<BaseItem>() != null)
        {
            if (g.GetComponent<BaseItem>().material == BaseItem.ObjectMaterial.Wood)
            {
                g.AddComponent<FireState>();
                FireState fireObject = (FireState)g.AddComponent<FireState>();
                fireObject.particleEffect = particleSystem;
                fireObject.target = g;
                fireObject.StartEffect();
                return true;
            }
            else
                return false;
        }
        else
            return false;
    }

    bool IsBlacklisted(Vector3 p)
    {
        for (int i=0;i<blacklistPoints.Count;i++)
        {
            if (blacklistPoints[i] == p)
            {
                return true;
            }
        }
        return false;
    }
}
